// Creacion de una libreria para validar el NIF y el DNI
// Autor: Juan Antonio Jimenez
// Fecha: 2001 12 12

// La letra del NIF se genera conociendo nicamente el 
// numero del DNI. Aplicndole a ste una serie de 
// transformaciones (modulo 23), se obtiene un nmero
// entre 0 y 22 que ordeno en el siguiente array.

letras = new Array();
	letras[0]  = "T";
	letras[1]  = "R";
	letras[2]  = "W";
	letras[3]  = "A";
	letras[4]  = "G";
	letras[5]  = "M";
	letras[6]  = "Y";
	letras[7]  = "F";
	letras[8]  = "P";
	letras[9]  = "D";
	letras[10] = "X";
	letras[11] = "B";
	letras[12] = "N";
	letras[13] = "J";
	letras[14] = "Z";
	letras[15] = "S";
	letras[16] = "Q";
	letras[17] = "V";
	letras[18] = "H";
	letras[19] = "L";
	letras[20] = "C";
	letras[21] = "K";
	letras[22] = "E";
	
	
function nif(dni){
	//dado un DNI te devuelve el NIF
	dni = parseInt(dni); 	//con esto le quitariamos los ceros que tenga por delante
	if (dni > 99999999){
		alert("Error. El DNI slo tiene 8 dgitos")
	}else{
		letraDNI = letras[dni % 23];
		dni = dni.toString(); 	//lo convertimos a String para poderlo concatenar con la letra
		nif = dni + letraDNI;
		return nif
	}
}

function esNIFCorrecto(nif){
	//dado un NIF te devuelve si es o no correcto
	txtError = "";			//texto que se mostrara en caso de error
	ok = true;				//variable booleana que controla si hay algn error
	dni=nif.substring(0,nif.length-1);	//del NIF nos quedamos con el DNI
	dni=parseInt(dni);					//al convertirlo a entero, le quitamos los ceros de la izquierda
	letra=nif.charAt(nif.length-1);		//la letra que nos han pasado
	letraCorrecta = letras[ dni % 23];	//la letra que debera ser para ese DNI

	if (dni > 99999999){ 
		txtError += "El DNI tiene a lo sumo 8 cifras\n";
		ok = false;
	} else if(letra<"a" || letra>"Z"){
		txtError += "El ltimo carcter del NIF debe ser una letra"
		ok = false;
	} else if(letra!=letraCorrecta) {
		txtError += "La letra correcta del NIF para ese DNI es " + letraCorrecta + "\n";
		ok = false;
	}
	
	if (ok) {
		return true;
	}else{
		alert(txtError);
		return false;
	}
}
